/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__MCP_REQUEST_RING_H
#define MX__MCP_REQUEST_RING_H

#define MCP_USE_REQUEST_QUEUE 0

struct mx__mcp_request_ring
{
  mcp_ureq_t *base;
  int tail; /* Location to insert next request. */
  int max;
  int mask;
};

/* p - pointer to mmapped lanai sram where request ring starts */
/* length - number of bytes in the request ring */
void mx__mcp_request_ring_init(struct mx__mcp_request_ring *ring, char *p,
			       int length);

/* Returns a pointer to next available mcp request, 0 if none are
   available. */
static inline
mcp_ureq_t *mx__get_ureq(struct mx__mcp_request_ring *ring, int mcp_handle)
{
#if MCP_USE_REQUEST_QUEUE
  return ring->base + mcp_handle;
#else
  mcp_ureq_t *ureq;
  ureq = ring->base + ring->tail;
  ring->tail = (ring->tail+1) & ring->mask;
  return ureq;
#endif
}

#endif
